// Move.cpp: implementation of the Move class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Move.h"

#include <iostream>
using namespace std;

#define PAWN 0
#define KNIGHT 1
#define BISHOP 2
#define ROCK 3
#define QUEEN 4
#define KING 5

#define WHITE_SHORT_CASTLE 0
#define BLACK_SHORT_CASTLE 1
#define WHITE_LONG_CASTLE 2
#define BLACK_LONG_CASTLE 3

#define WHITE 0
#define BLACK 1
#define EMPTY 2

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Move::Move()
{
	From = 0;
	To = 0;
	MovingPiece = 0;
	MovingSide = 0;
	DestinationPiece = 0;
	DestinationSide = 0;
	PieceToPromote = 0;
	Score = 0;
	CastleMoveCode = -1;
	Check = false;
	Promote = false;
	Capture = false;
}

Move::~Move()
{
	
}

void Move::PrintMove()
{
	if (MovingPiece == PAWN)
	{
		if (Capture)
		{
			PrintColumnFromSquareNumber(From);
			cout << "x";
			PrintColumnFromSquareNumber(To);
			PrintRankFromSquareNumber(To);
		}
		else
		{
			PrintColumnFromSquareNumber(To);
			PrintRankFromSquareNumber(To);
		}
		if (Promote)
		{
			cout << "=";
			PrintPieceLetter(PieceToPromote);
		}
	}
	else
	{
		if (CastleMoveCode == WHITE_SHORT_CASTLE || CastleMoveCode == BLACK_SHORT_CASTLE)
			cout << "0-0";
		else if (CastleMoveCode == WHITE_LONG_CASTLE || CastleMoveCode == BLACK_LONG_CASTLE)
			cout << "0-0-0";
		else
		{
			PrintPieceLetter(MovingPiece);
			PrintColumnFromSquareNumber(From);
			if (Capture)
				cout << "x";
			
			PrintColumnFromSquareNumber(To);
			PrintRankFromSquareNumber(To);

			if (Check)
				cout << "+";
		}
	}
}

void Move::PrintPieceLetter(int piece)
{
	if (piece == KNIGHT)
		cout << "N";
	else if (piece == BISHOP)
		cout << "B";
	else if (piece == ROCK)
		cout << "R";
	else if (piece == QUEEN)
		cout << "Q";
	else
		cout << "K";
}

void Move::PrintColumnFromSquareNumber(int square)
{
    if ((square % 8) == 0)
        cout << "a";
    else if (((square + 7) % 8) == 0)
        cout << "b";
    else if (((square + 6) % 8) == 0)
        cout << "c";
    else if (((square + 5) % 8) == 0)
        cout << "d";
    else if (((square + 4) % 8) == 0)
        cout << "e";
    else if (((square + 3) % 8) == 0)
        cout << "f";
    else if (((square + 2) % 8) == 0)
		cout << "g";
    else
        cout << "h";
}

void Move::PrintRankFromSquareNumber(int square)
{
    if (square <= 7)
        cout << "1";
    else if (square <= 15)
        cout << "2";
    else if (square <= 23)
        cout << "3";
    else if (square <= 31)
        cout << "4";
    else if (square <= 39)
        cout << "5";
    else if (square <= 47)
        cout << "6";
    else if (square <= 55)
        cout << "7";
    else 
        cout << "8";
}


int Move::GetPreevaluateScore()
{
	if (Promote && Capture)
		return PieceToPromote + DestinationPiece + 6 - MovingPiece;
	else if (Promote)
		return PieceToPromote;
	else if (Capture)
		return DestinationPiece + 6 - MovingPiece;
	else
	{
		int pawnPushesScore = 0;
		
		if (MovingPiece == PAWN && MovingSide==WHITE)
		{
			if (To>39)
				pawnPushesScore = 100;
			else if (To>47)
				pawnPushesScore = 200;
			else if (To>55)
				pawnPushesScore = 300;
		}
		else if (MovingPiece == PAWN && MovingSide==BLACK)
		{
			if (To<24)
				pawnPushesScore = 100;
			else if (To<16)
				pawnPushesScore = 200;
			else if (To<8)
				pawnPushesScore = 300;
		}
		

		int score = (CastleMoveCode != -1)? 10 + pawnPushesScore:pawnPushesScore;
		return score;
	}
}
